package com.javainuse.bank.service;

import org.springframework.stereotype.Service;

import com.javainuse.banking.AccountBalanceResponse;
import com.javainuse.banking.AccountBalanceServiceGrpc;
import com.javainuse.banking.AccountRequest;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;

@Service
public class BankService {

	public void getAccountBalance() {

		ManagedChannel channel = ManagedChannelBuilder.forAddress("localhost", 8090).usePlaintext().build();

		AccountBalanceServiceGrpc.AccountBalanceServiceBlockingStub stub = AccountBalanceServiceGrpc
				.newBlockingStub(channel);

		AccountBalanceResponse bookResponse = stub
				.getAccountBalance(AccountRequest.newBuilder().setAccountNumber("account5").build());

		System.out.println(bookResponse);

		channel.shutdown();

	}

}
