package com.javainuse.bank.service;

import org.springframework.stereotype.Service;

import com.javainuse.banking.AccountBalanceResponse;
import com.javainuse.banking.AccountBalanceServiceGrpc;
import com.javainuse.banking.AccountRequest;
import com.javainuse.banking.CustomError;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.ProtoUtils;

@Service
public class BankService {

	public void getAccountBalance() {

		ManagedChannel channel = ManagedChannelBuilder.forAddress("localhost", 8090).usePlaintext().build();

		AccountBalanceServiceGrpc.AccountBalanceServiceBlockingStub stub = AccountBalanceServiceGrpc
				.newBlockingStub(channel);

		try {

			AccountBalanceResponse bookResponse = stub
					.getAccountBalance(AccountRequest.newBuilder().setAccountNumber("account5").build());

			System.out.println(bookResponse);
		} catch (StatusRuntimeException ex) {
			Status status = ex.getStatus();
			System.out.println("error code -" + status.getCode());
			System.out.println("error description -" + status.getDescription());
			
			Metadata metadata = Status.trailersFromThrowable(ex);
			Metadata.Key<CustomError> customErrorKey = ProtoUtils.keyForProto(CustomError.getDefaultInstance());
			CustomError customError = metadata.get(customErrorKey);
			System.out.println(customError);
		}

		channel.shutdown();

	}

}
